<?php
// Include database connection
include("db.php");

// Include PHPMailer classes with namespaces
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';
require 'PHPMailer/src/Exception.php';

// Set content type to JSON
header('Content-Type: application/json');



// Check if the method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get the raw POST data
    $rawData = file_get_contents('php://input');
    $data = json_decode($rawData, true);

    // Validate email or phone
    if (empty($data['email']) && empty($data['phone'])) {
        echo json_encode(['status' => 'error', 'message' => 'Email or phone number is required']);
        exit();
    }

    $email = isset($data['email']) ? $conn->real_escape_string($data['email']) : null;
    $phone = isset($data['phone']) ? $conn->real_escape_string($data['phone']) : null;

    // Determine whether to process email or phone
    if ($email) {
        $sql = "SELECT Id, Name FROM user_login WHERE Email = '$email' AND Delete_status = 0 LIMIT 1";
    } elseif ($phone) {
        $sql = "SELECT Id, Name FROM user_login WHERE Phone = '$phone' AND Delete_status = 0 LIMIT 1";
    }

    $result = $conn->query($sql);

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();
        $userId = $user['Id'];
        $name = $user['Name'];

        // Generate a 4-digit OTP
        $otp = rand(1000, 9999);

        // Save the OTP in the database
        $updateSql = "UPDATE user_login SET Otp = '$otp', Status = 0 WHERE Id = '$userId'";
        if ($conn->query($updateSql)) {
            if ($email) {
                // Send OTP to email
                $mail = new PHPMailer();
                $mail->isSMTP();
                $mail->Host = 'smtp.gmail.com'; // Replace with your SMTP server
                $mail->SMTPAuth = true;
                $mail->Username = 'rfghee2k23@gmail.com'; // Replace with your email
                $mail->Password = 'vdoi hydc bjja orgc';    // Replace with your email password
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                $mail->Port = 587;

                $mail->setFrom('rfghee2k23@gmail.com', 'Hapi commerce');
                $mail->addAddress($email);

                $mail->isHTML(true);
                $mail->Subject = 'Forgot Password OTP';
                $mail->Body = "<p>Hello $name,</p><p>Your OTP for password reset is: <strong>$otp</strong></p><p>Thank you,</p><p>Hapi commerce</p>";

                if ($mail->send()) {
                    echo json_encode(['status' => 'success', 'message' => 'OTP sent to your email']);
                } else {
                    echo json_encode(['status' => 'error', 'message' => 'Failed to send email']);
                }
            } elseif ($phone) {
                // Send OTP via Fast2SMS API
                $fields = array(
                    "variables_values" => $otp,  // OTP to send
                    "route" => "otp",            // OTP route
                    "numbers" => $phone          // Recipient phone number
                );
                
                $curl = curl_init();
                
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.fast2sms.com/dev/bulkV2",  // Fast2SMS API URL
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_SSL_VERIFYHOST => 0,
                    CURLOPT_SSL_VERIFYPEER => 0,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => json_encode($fields),  // Send the fields as JSON
                    CURLOPT_HTTPHEADER => array(
                        "authorization: K13dusTCcx5aJpqbMSyBPijrfLW7IDlFGYOhZUVzvoN0AnQ2RHBrGjbkhJS3aT8KsXDYdzFWtx5Oe1u7", // API key for Fast2SMS
                        "accept: */*",
                        "cache-control: no-cache",
                        "content-type: application/json"
                    ),
                ));
                
                // Execute the cURL request
                $smsResponse = curl_exec($curl);
                $err = curl_error($curl);
                curl_close($curl);
                
                if ($err) {
                    // If there's an error with the cURL request, output the error
                    echo json_encode(['status' => 'error', 'message' => 'Failed to send SMS: ' . $err]);
                } else {
                    // Decode the JSON response from Fast2SMS
                    $responseDecoded = json_decode($smsResponse, true);
                
                    if ($responseDecoded['return']) {
                        // Success: SMS sent successfully
                        echo json_encode(['status' => 'success', 'message' => 'OTP sent to your phone']);
                    } else {
                        // Failure: Unable to send SMS
                        $errorMessage = isset($responseDecoded['message']) ? (is_array($responseDecoded['message']) ? implode(", ", $responseDecoded['message']) : $responseDecoded['message']) : "Failed to send SMS";
                        echo json_encode(['status' => 'error', 'message' => $errorMessage]);
                    }
                    
                }
            }
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to save OTP']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => ($email ? 'Email' : 'Phone number') . ' not found']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
}

$conn->close();
?>
